// Camera Mask.js

function buildUI( obj ) {
	
	obj.setParameter("name", "Camera Mask");

	obj.addParameterSeparator("Mask");
	
    obj.addParameterLink("target cam", true);
    
    obj.addParameterFloat("clip center x", 0, -0.5, 0.5, true, false);
    obj.addParameterFloat("clip center y", 0, -0.5, 0.5, true, false);
    obj.addParameterFloat("clip width", 0.1, 0, 1, true, false);
    obj.addParameterFloat("clip height", 0.1, 0, 1, true, false);
    
    obj.addParameterFloat("z distance", -0.8, -1000, 0, true, false);
    
    obj.addParameterSeparator("Helper");
    obj.addParameterButton("add render tag", "add", "addRenderTag");
}

function addRenderTag( obj ) {
    var tag = obj.addTagOfType(114); // 114 is render tag's number
    
    tag.setParameter("castShadows", false);
    tag.setParameter("receiveShadows", false);
    tag.setParameter("receiveHDRIReflections", false);
    tag.setParameter("visibleInRadiosity", false);
    tag.setParameter("visibleInCaustics", false);
    tag.setParameter("visibleInReflections", false);
    tag.setParameter("visibleInRefractions", false);
    tag.setParameter("receiveRadiosity", false);
    tag.setParameter("receiveCaustics", false);
    
}
function buildObject( obj ) {
    var cam = obj.getParameter("target cam");
    
    if (!cam || cam.type() != CAMERA)
        return;
    
    obj.setParameter("normalType",0,false);
    
    var mat = obj.obj2WorldMatrix().inverse();
    var camMat = cam.obj2WorldMatrix();
    
    var core = obj.core();
    
    var resX = cam.getParameter("resolutionX");
    var resY = cam.getParameter("resolutionY");
    
    var centerx = obj.getParameter("clip center x");
    var centery = obj.getParameter("clip center y");
    var width = obj.getParameter("clip width");
    var height = obj.getParameter("clip height");
    
    var dz = obj.getParameter("z distance");
    
    var v0 = new Vec3D( -0.5,  0.5 * (resY/resX), dz );
    var v1 = new Vec3D(  0.5,  0.5 * (resY/resX), dz );
    var v2 = new Vec3D(  0.5, -0.5 * (resY/resX), dz );
    var v3 = new Vec3D( -0.5, -0.5 * (resY/resX), dz );
    
    
    var v4 = new Vec3D( centerx-width/2,  centery+height/2, dz );
    var v5 = new Vec3D( centerx+width/2,  centery+height/2, dz ) ;
    var v6 = new Vec3D( centerx+width/2, centery-height/2, dz ) ;
    var v7 = new Vec3D( centerx-width/2, centery-height/2, dz ) ;
    
    var p0 = core.addVertex( false, mat.multiply(camMat.multiply(v0)) );
    var p1 = core.addVertex( false, mat.multiply(camMat.multiply(v1)) );
    var p2 = core.addVertex( false, mat.multiply(camMat.multiply(v2)) );
    var p3 = core.addVertex( false, mat.multiply(camMat.multiply(v3)) );
    var p4 = core.addVertex( false, mat.multiply(camMat.multiply(v4)) );
    var p5 = core.addVertex( false, mat.multiply(camMat.multiply(v5)) );
    var p6 = core.addVertex( false, mat.multiply(camMat.multiply(v6)) );
    var p7 = core.addVertex( false, mat.multiply(camMat.multiply(v7)) );
    
    core.addIndexPolygon( 4, [p3, p7, p4, p0] );
    core.addIndexPolygon( 4, [p4, p5, p1, p0] );
    core.addIndexPolygon( 4, [p6, p2, p1, p5] );
    core.addIndexPolygon( 4, [p7, p3, p2, p6] );
}